#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Plasma 90xMod01.fsh   by   bitek
//https://www.shadertoy.com/view/4ssGR7
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// A classic plasm shader. (c) Ajarus, viktor@ajarus.com; 1996.
//
// Attribution-ShareAlike CC License.

//----------------
  const int ps = 0; // play with values 0..10
//----------------


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
   float x = fragCoord.x / iResolution.x * 640.;
   float y = fragCoord.y / iResolution.y * 480.;
   
	if (ps > 0)
	{
	   x = float(int(x / float(ps)) * ps);
	   y = float(int(y / float(ps)) * ps);
	}
	
   float mov0 = x+y+sin(iTime)*10.+sin(x/90.)*70.+iTime*2.;
   float mov1 = (mov0 / 5. + sin(mov0 / 30.))/ 10. + iTime * 3.;
   float mov2 = mov1 + sin(mov1)*5. + iTime*1.0;
   float cl1 = sin(sin(mov1/4. + iTime)+mov1);
   float c1 = cl1 +mov2/2.-mov1-mov2+iTime;
   float c2 = sin(c1+sin(mov0/100.+iTime)+sin(y/57.+iTime/50.)+sin((x+y)/200.)*2.);
   float c3 = abs(sin(c2+cos((mov1+mov2+c2) / 10.)+cos((mov2) / 10.)+sin(x/80.)));
  
   float dc = float(16-ps);
	
	if (ps > 0)
	{
   		cl1 = float(int(cl1*dc))/dc;
   		c2 = float(int(c2*dc))/dc;
   		c3 = float(int(c3*dc))/dc;
	}
	
   fragColor = vec4( cl1,c2,c3,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

